/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.world.block.BaseFence;
import com.voxelutopia.ultramarine.world.block.BaseWall;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final List<RegistryObject<Block>> NON_SIMPLE_BLOCKS = new ArrayList<RegistryObject<Block>>();
    private static final List<RegistryObject<Item>> NON_SIMPLE_ITEMS = new ArrayList<RegistryObject<Item>>();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ultramarine", existingFileHelper);
    }

    protected void registerModels() {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> !NON_SIMPLE_BLOCKS.contains(blockRegistryObject)).forEach(this::blockItem);
        this.wallInventory(this.name((Block)BlockRegistry.BLACK_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.BLACK_BRICKS.get()));
        this.wallInventory(this.name((Block)BlockRegistry.CYAN_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.CYAN_BRICKS.get()));
        this.wallInventory(this.name((Block)BlockRegistry.CYAN_FLOOR_TILE_WALL.get()), this.blockLoc((Block)BlockRegistry.CYAN_FLOOR_TILE.get()));
        this.wallInventory(this.name((Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE_WALL.get()), this.blockLoc((Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE.get()));
        this.wallInventory(this.name((Block)BlockRegistry.BROWNISH_RED_STONE_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.BROWNISH_RED_STONE_BRICKS.get()));
        this.wallInventory(this.name((Block)BlockRegistry.POLISHED_WEATHERED_STONE_WALL.get()), this.blockLoc((Block)BlockRegistry.POLISHED_WEATHERED_STONE.get()));
        this.fenceInventory(this.name((Block)BlockRegistry.ROSEWOOD_FENCE.get()), this.blockLoc((Block)BlockRegistry.ROSEWOOD_PLANKS.get()));
        ItemRegistry.ITEMS.getEntries().stream().filter(blockRegistryObject -> !NON_SIMPLE_ITEMS.contains(blockRegistryObject)).filter(blockRegistryObject -> !(blockRegistryObject.get() instanceof BlockItem)).forEach(this::generatedItem);
    }

    private ItemModelBuilder generatedItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)this.singleTexture(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)item.get()))).m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + item.get()));
    }

    private ItemModelBuilder blockItem(RegistryObject<Block> block) {
        return (ItemModelBuilder)this.withExistingParent(this.name((Block)block.get()), this.modLoc("block/" + block.get()));
    }

    private ResourceLocation blockLoc(Block block) {
        return this.modLoc("block/" + this.name(block));
    }

    private String name(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
    }

    @NotNull
    public String m_6055_() {
        return "ultramarine Item Models";
    }

    static {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof BaseWall || blockRegistryObject.get() instanceof BaseFence).forEach(NON_SIMPLE_BLOCKS::add);
    }
}

